﻿// DOM method shortcuts for typing sanity
var d = {
	ce : function(obj){
		return document.createElement(obj);
	},
	
	ct : function(str){
		return document.createTextNode(str);
	},	
	
	ac : function(pNode,cNode){
		pNode.appendChild(cNode);
	},	
	
	acb	: function(refNode,addNode){ //append element before
		var pNode = refNode.parentNode;
		pNode.insertBefore(addNode, refNode);
		
	},	
	
	sa : function(obj,attr,val){
		obj.setAttribute(attr,val);
	},
	
	ge : function(objID){
		return document.getElementById(objID);
	},
	
	ga : function(str){
		return obj.getAttribute(attr);
	},
	
	gebc : function(searchClass,node,tag) {
		var classElements = new Array();
		if ( node == null )
			node = document;
		if ( tag == null )
			tag = '*';
		var els = node.getElementsByTagName(tag);
		var elsLen = els.length;
		var pattern = new RegExp("(^|\\s)"+searchClass+"(\\s|$)");
		for (i = 0, j = 0; i < elsLen; i++) {
			if ( pattern.test(els[i].className) ) {
				classElements[j] = els[i];
				j++;
			}
		}
		return classElements;
	}
}


// string functions
var S = {
	trim: function(txt) {
		if(!txt){return ''};
		txt = txt.replace(/^\s+/, '');
		txt = txt.replace(/\s+$/, '');
		return txt;
	},
	
	// escape function, escapes character ch
	esc : function(txt, ch) {
		if(!txt){return ''};
		if(!ch) {
		 	ch = '"';
		}
		var re = new RegExp(ch, "g");
		txt = txt.replace(re, "\\"+ch);		
		return txt;
		
	}
}