<?php
class CHECKOUT_MOIP extends ISC_CHECKOUT_PROVIDER
{

        var $_requiresSSL = false;

	public function __construct()
	{
		// Setup the required variables for the PayPal checkout module
		parent::__construct();
		$this->_name = "MoIP";
		$this->_image = "moip.gif";
		$this->_description = "Modulo de Pagamento MoIP";
		$this->_help = "Modulo de Pagamento MoIP";
		$this->_height = 0;
	}

	/**
	 * Custom variables for the checkout module. Custom variables are stored in the following format:
	 * array(variable_id, variable_name, variable_type, help_text, default_value, required, [variable_options], [multi_select], [multi_select_height])
	 * variable_type types are: text,number,password,radio,dropdown
	 * variable_options is used when the variable type is radio or dropdown and is a name/value array.
	 */
	public function SetCustomVars()
	{

		$this->_variables['displayname'] = array("name" => "Nome",
		   "type" => "textbox",
		   "help" => GetLang('DisplayNameHelp'),
		   "default" => $this->GetName(),
		   "required" => true
		);

		$this->_variables['email'] = array("name" => "Email MoIP",
		   "type" => "textbox",
		   "help" => GetLang('PayPalEmailHelp'),
		   "default" => "",
		   "required" => true
		);

}

	/**
	 *	Redirect the customer to PayPal's site to enter their payment details
	 */
	public function TransferToProvider()
	{   
		$total = $this->GetTotal();
		$email = trim($this->GetValue("email"));

		$paypal_url = "https://www.moip.com.br/PagamentoMoIP.do";
	

		// Load the pending order
		$order = LoadPendingOrderByToken($_COOKIE['SHOP_ORDER_TOKEN']);

		$country = "Brasil";

		// Fetch the customer details
		$query = sprintf("SELECT * FROM [|PREFIX|]customers WHERE customerid='%s'", $GLOBALS['ISC_CLASS_DB']->Quote($order['ordcustid']));
		$result = $GLOBALS['ISC_CLASS_DB']->Query($query);
		$customer = $GLOBALS['ISC_CLASS_DB']->Fetch($result);

		$hiddenFields = array(
			'id_carteira' => $email,
						
			// Order details
			'nome'		=> sprintf(GetLang('YourOrderFromX'), GetConfig('StoreName')).' (Pedido #'.$order['orderid'].')',
			'valor'		=> str_replace(array("R$"," ",".",","),array(NULL,NULL,NULL,NULL),number_format($total, 2, '', '')),
			'id_transacao'	=> $order['orderid'],
			'peso_compra'	=> 0,
			
			// Customer details
			'pagador_nome'	=> $customer['custconfirstname'],
			'pagador_email'			=> $customer['custconemail'],
			'pagador_logradouro'		=> $order['ordbillstreet1'],
			'pagador_telefone'	=> str_replace(array("(",")"," ","-","."),array(NULL,NULL,NULL,NULL,NULL),$customer['custconphone']),
			'pagador_pais'		=> $country,
			'pagador_cep'			=> str_replace(array("(",")"," ","-","."),array(NULL,NULL,NULL,NULL,NULL),$order['ordbillzip']),
			'pagador_cidade'			=> $order['ordbillsuburb'],
		);
		$this->RedirectToProvider($paypal_url, $hiddenFields);
	}

	/**
	 *	Return the unique order token which was saved as a cookie pre-payment.
	 *
	 * @return string The order token.
	 */
	public function GetOrderToken()
	{
		return @$_COOKIE['SHOP_ORDER_TOKEN'];
	}


//////////////////////////////////////////////////////

		function GetForcedStatus()
		{
			return ORDER_STATUS_AWAITING_PAYMENT;
		}
}
?>